/* $Header: ReadPointCloud.java 13-feb-2007.03:18:23 rkothuri Exp $ */

/* Copyright (c) 2006, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     Read the Points LOB associated with a PointCloud Block.
       The Points LOB has n points each of the form:
        < d 8-byte doubles represeting the d numbers for d dimensions>,
        < 2 4-byte integers for representing a point using ptn_id, pt_id >


   PRIVATE CLASSES
    ReadPoint

   NOTES

   MODIFIED    (MM/DD/YY)
    rkothuri     10/30/06 - Creation
 */

/**
 *  @version $Header: ReadPointCloud.java 13-feb-2007.03:18:23 rkothuri Exp $
 *  @author  rkothuri 
 *  @since   release specific (what release of product did this appear in)
 *
 *  Reads the point LOB from the "blktab" of a Point Cloud.
 *  The LOB has n points each of the form:
 *  < d 8-byte doubles represeting the d numbers for d dimensions>, 
 *  < 2 4-byte integers for ptn_id, pt_id > 
 */

import oracle.spatial.util.*;
//import oracle.spatial.util.GML;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.*;
import java.io.*;
import java.util.*;
import oracle.jdbc.*;
import java.sql.*;

import oracle.sql.BLOB;
import oracle.sql.CLOB;

import oracle.sql.STRUCT;


public class ReadPointCloud 
{

    private static String host = "stadb28.us.oracle.com";
    private static String port = "1521";
    private static String sid = "sdo_11";
    private static String driver = "thin";
    private static String user = "scott";
    private static String password = "tiger";
    private static String fTable = "base";
    private static String fCol = "pc";
    private static String blkTable = "blktab";
    private static String blkCol = "pc";
    private static  Connection connection = null;

    
    /*************************************************************************/
    static private String usage()
    {
      return "Usage: java ReadPointCloud \n" +
             "-host hostName \n-port portNumber\n" +
             "-sid SID \n-driver jdbcDriver[thin:oci]\n" +
             "-user userName\n" +
             "-password password\n" ;
    }

    /*************************************************************************/
    public static void setConnection(){
      String connectString =
                "jdbc:oracle:" + driver + ":@"
                + "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(HOST="
                +  host + ")"
                + "(PROTOCOL=tcp)(PORT="
                + port + ")))"
                + "(CONNECT_DATA=(SID="
                + sid + ")))";
                                                                                 
      try {
        DriverManager.registerDriver(new OracleDriver());
        connection = DriverManager.getConnection(
                       connectString, user, password);
                                                                                 
      }
      catch (Throwable t)
      {
        System.out.println(
                        t.toString() + ": \n" + t.getMessage() +
                        "Error attempting to connect to database");
       }

     }
    /*************************************************************************/
    public static Connection getConnection() { return connection; }

    /*************************************************************************/
    private static void processCmdLineArgs(String[] args)
    {
                                                                                 
        // process db connection information
      
          if ( args.length > 0  )
         {
            for ( int i = 0 ; i < args.length ;i++ )
            {
              if ( args[i].equalsIgnoreCase("-host") )
                host = args[++i];
              else if ( args[i].equalsIgnoreCase("-port") )
                port = args[++i];
              else if ( args[i].equalsIgnoreCase("-sid") )
                sid = args[++i];
              else if ( args[i].equalsIgnoreCase("-driver") )
                driver = args[++i];
              else if ( args[i].equalsIgnoreCase("-user") )
                user = args[++i];
              else if ( args[i].equalsIgnoreCase("-password") )
                password = args[++i];
              else if ( args[i].equalsIgnoreCase("-h") )
              {
                 System.out.println(usage());
                 System.exit(0);
              }
           }
         }
	 else {
                System.out.println("Using default parameters");
         }
         setConnection();
      
    }
    /*************************************************************************/


  public static void main(String args[])
    throws IOException
  {    
   
    processCmdLineArgs(args);

        // assume # of dimensions to be 3
        int ndim = 3;
    
        double[] ords = new double[ndim];
        
        // get #poitns, points lob from blktab
        String sqlStr = "SELECT num_points, points FROM "
           + " blktab ";
        Connection conn = getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        DataInputStream dis = null;
        try
        {

          stmt = conn.createStatement ();
          rset = stmt.executeQuery (sqlStr);

          while (rset.next ())
          {
            int num_points  = rset. getInt(1);
            System.out.println("Numpoints = " + num_points);
            Blob blob = rset.getBlob(2);
            dis = new DataInputStream(blob.getBinaryStream());
            for (int i=0 ; i< num_points; i++) {
             // first 8*ndim bytes are ndim doubles
             for (int j=0; j<ndim; j++) {
                ords[j] = dis.readDouble();
             }
             // read the ptn_id
             int ptn_id = dis.readInt();
             
             // read the pt_id
             int pt_id = dis.readInt();
             
             System.out.println("<"+ptn_id+","+pt_id + ">"+ ords[0] + ","+ ords[1]);
            }
            
          }
        } catch (SQLException e)
        {
          System.out.println("Error: " + e.getMessage());
        }
        finally { 
          try {
            if (rset != null)    {rset.close(); rset = null;}
            if (stmt !=null)     {stmt.close(); stmt = null;}
            if (dis!=null)       {dis.close(); dis = null;}
          }
          catch (SQLException ex) {}
        }
  }
}


